VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   10635
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   14265
   LinkTopic       =   "Form1"
   ScaleHeight     =   10635
   ScaleWidth      =   14265
   StartUpPosition =   3  'Windows-Standard
   Begin CairoTutorial.ucCanvas ucCanvas1 
      Height          =   4515
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   8175
      _ExtentX        =   14420
      _ExtentY        =   7964
   End
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'this example basically does the same thing as the nice SVG-Demo at:
'http://people.mozilla.com/~vladimir/demos/photos.svg
'but of course without any SVGs (yet) or SVG-embedded JavaScript... ;-)
'
'Note, that the performance is better here than within the FireFox-
'Browser (which is using Cairo as the Rendering-Backend too), though
'mainly because we use a BackGround-Surface-Buffering for all the
'"already drawn, not actively dragged" Images...
'
'The Form-Code is pretty small (and IMO yet easy to understand) -
'the main-work is encapsulated within the cImageResizer-Class - which does
'"a bit more math" this time (compared with the other "Shape-Helper-Objects"
'of the former Demos) - hope you will make your way through cImageResizer
'anyways - nonetheless the results are nice, aren't they?
'So, thanks to the guys who wrote a first Silverlight-Demo for stuff
'like that - and to Vladimir for his port into a FireFox/SVG-based demo!
'
'...Touch-Displays, here we come! <g>
'
'Another note, about the 4 used Images (all relative high-res JPGs with
'an average size of about 200kByte) -> one of them (the "NASA-snapshot")
'is different from the other JPGs, since it not only contains a normal
'JPG-stream "at the front" - but appended in the file is a second JPG-stream
'(directly behind the normally colored, first one), which contains a real
'Alpha-Channel (encoded as a Gray-JPG with a somewhat higher JPG-Quality).
'And although this is a proprietary feature of the wrapper (supported in
'read and write-direction), it can be very useful IMO - e.g. when your VB-
'App needs to deploy a lot of resource-images, which require an Alpha-Channel
'(as in HighRes-Icons or the usual *.png-Images). The feature already reduced
'the size of this Demo-Download by roughly 1.5MB, since the original world.png-
'image (in the same 1024x1024 resolution) was 1849kByte - where the Alpha-JPG
'(encoded in our Image1.jpg) only needs 266kByte - with no apparent "visual
'degradation" - but achieving the desired Masking-Effect as well, behaving
'within our Demo in the same way, as the original Png would have (by rendering
'only the Globe).

Private ImageResizers As New cCollection, BackBuf As cCairoSurface
Attribute ImageResizers.VB_VarHelpID = -1

Private Sub Form_Load()
Dim i&, ImageKey As String, ImageResizer As cImageResizer

  Caption = "Drag the Control-Points"
  Me.ScaleMode = vbPixels

  Rnd -2
  For i = 1 To 4
    'let's load our 4 resource-images into our global Cairo.ImageList
    ImageKey = "Image" & i
    Cairo.ImageList.AddImage ImageKey, App.Path & "\" & ImageKey & ".jpg"
    
    'as well as create and init appropriate Handler-/Resizer-Instances
    Set ImageResizer = New cImageResizer
    ImageResizer.Init ucCanvas1.ControlPoints, ImageKey, i * 175, Rnd * 400 + 200, 100, Rnd * 14 * Atn(1)
    ImageResizers.Add ImageResizer, ImageKey
  Next i
End Sub

Private Sub Form_Resize()
  Set BackBuf = Nothing 'we use the BackBufs "Nothing-State" also as a "Boolean Flag" in our Main-Draw-Routine (to refresh it)
  If ScaleHeight - ucCanvas1.Top > 0 Then ucCanvas1.Move 0, ucCanvas1.Top, ScaleWidth, ScaleHeight - ucCanvas1.Top
End Sub

'a small Public Sub in the Form-interface, which is called from within cImageResizer later on,
'to move it "visually" to the front (in terms of rendering-order: = to the end of the ImageResizers-Collection)
Public Sub MoveToFront(ImageResizer As cImageResizer)
Dim i&
  For i = 1 To ImageResizers.Count
    If ImageResizers(i) Is ImageResizer Then Exit For
  Next i
  ImageResizers.Remove i
  ImageResizers.Add ImageResizer, ImageResizer.ImageKey
  
  Set BackBuf = Nothing 'signalize a Refresh of the BackBuffer here too
End Sub

Private Sub ucCanvas1_RefreshContents(CC As dhCairo.cCairoContext)
  Draw CC
End Sub

Private Sub Draw(CC As cCairoContext)
Dim i&, BackCC As cCairoContext
  
  If BackBuf Is Nothing Then 'if the App signalizes so, then lets-"Redim" and repaint our "BackBuffer-Cache"
    Set BackBuf = Cairo.CreateSurface(ucCanvas1.Width, ucCanvas1.Height) 'same size as the ucCanvas-Surface
    Set BackCC = BackBuf.CreateContext
    
    'the following two lines ensure a complete Surface-Fill
    BackCC.SetSourceColor &HC6C5C4
    BackCC.Paint
    
    'now the redrawing of "all-other" ImageResizer-Objects, but we spare out the last entry in the Collection (our Top-Image)
    For i = 1 To ImageResizers.Count - 1
      ImageResizers(i).Draw BackCC
    Next i
  End If
  
  CC.RenderSurfaceContent BackBuf, 0, 0 'and here we can do a fast "Blit" from our BackBuffer (containing everything else but our TopImage)
  ImageResizers(ImageResizers.Count).Draw CC 'and on Top we only need to draw our current LastEntry in the collection
  
  ucCanvas1.Refresh
End Sub

